<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Diabet extends Model 
{

    protected $table = 'diabetes';
    public $timestamps = true;
    protected $fillable = array('history_id', 'who_has');

    public function medicalHistories()
    {
        return $this->belongsTo('App\Models\User', 'history_id');
    }

    public function familyMember()
    {
        return $this->hasOne('App\Models\PossibleMembersList', 'who_has');
    }

}